// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Static input data definition. </summary>
    public partial class StaticInputData : MonitoringInputDataBase
    {
        /// <summary> Initializes a new instance of <see cref="StaticInputData"/>. </summary>
        /// <param name="jobInputType"> [Required] Specifies the type of job. </param>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <param name="windowStart"> [Required] The start date of the data window. </param>
        /// <param name="windowEnd"> [Required] The end date of the data window. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        public StaticInputData(JobInputType jobInputType, Uri uri, DateTimeOffset windowStart, DateTimeOffset windowEnd) : base(jobInputType, uri)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            WindowStart = windowStart;
            WindowEnd = windowEnd;
            InputDataType = MonitoringInputDataType.Static;
        }

        /// <summary> Initializes a new instance of <see cref="StaticInputData"/>. </summary>
        /// <param name="inputDataType"> [Required] Specifies the type of signal to monitor. </param>
        /// <param name="dataContext"> The context metadata of the data source. </param>
        /// <param name="jobInputType"> [Required] Specifies the type of job. </param>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <param name="columns"> Mapping of column names to special uses. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="windowStart"> [Required] The start date of the data window. </param>
        /// <param name="windowEnd"> [Required] The end date of the data window. </param>
        /// <param name="preprocessingComponentId"> Reference to the component asset used to preprocess the data. </param>
        internal StaticInputData(MonitoringInputDataType inputDataType, string dataContext, JobInputType jobInputType, Uri uri, IDictionary<string, string> columns, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset windowStart, DateTimeOffset windowEnd, string preprocessingComponentId) : base(inputDataType, dataContext, jobInputType, uri, columns, serializedAdditionalRawData)
        {
            WindowStart = windowStart;
            WindowEnd = windowEnd;
            PreprocessingComponentId = preprocessingComponentId;
            InputDataType = inputDataType;
        }

        /// <summary> Initializes a new instance of <see cref="StaticInputData"/> for deserialization. </summary>
        internal StaticInputData()
        {
        }

        /// <summary> [Required] The start date of the data window. </summary>
        [WirePath("windowStart")]
        public DateTimeOffset WindowStart { get; set; }
        /// <summary> [Required] The end date of the data window. </summary>
        [WirePath("windowEnd")]
        public DateTimeOffset WindowEnd { get; set; }
        /// <summary> Reference to the component asset used to preprocess the data. </summary>
        [WirePath("preprocessingComponentId")]
        public string PreprocessingComponentId { get; set; }
    }
}
