// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class SparkJobScalaEntry : IUtf8JsonSerializable, IJsonModel<SparkJobScalaEntry>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SparkJobScalaEntry>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SparkJobScalaEntry>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SparkJobScalaEntry>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SparkJobScalaEntry)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("className"u8);
            writer.WriteStringValue(ClassName);
        }

        SparkJobScalaEntry IJsonModel<SparkJobScalaEntry>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SparkJobScalaEntry>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SparkJobScalaEntry)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSparkJobScalaEntry(document.RootElement, options);
        }

        internal static SparkJobScalaEntry DeserializeSparkJobScalaEntry(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string className = default;
            SparkJobEntryType sparkJobEntryType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("className"u8))
                {
                    className = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sparkJobEntryType"u8))
                {
                    sparkJobEntryType = new SparkJobEntryType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SparkJobScalaEntry(sparkJobEntryType, serializedAdditionalRawData, className);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClassName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  className: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClassName))
                {
                    builder.Append("  className: ");
                    if (ClassName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ClassName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ClassName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SparkJobEntryType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sparkJobEntryType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  sparkJobEntryType: ");
                builder.AppendLine($"'{SparkJobEntryType.ToString()}'");
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SparkJobScalaEntry>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SparkJobScalaEntry>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SparkJobScalaEntry)} does not support writing '{options.Format}' format.");
            }
        }

        SparkJobScalaEntry IPersistableModel<SparkJobScalaEntry>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SparkJobScalaEntry>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSparkJobScalaEntry(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SparkJobScalaEntry)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SparkJobScalaEntry>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
