// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The SparkJobPythonEntry. </summary>
    public partial class SparkJobPythonEntry : SparkJobEntry
    {
        /// <summary> Initializes a new instance of <see cref="SparkJobPythonEntry"/>. </summary>
        /// <param name="file"> [Required] Relative python file path for job entry point. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="file"/> is null. </exception>
        public SparkJobPythonEntry(string file)
        {
            Argument.AssertNotNull(file, nameof(file));

            File = file;
            SparkJobEntryType = SparkJobEntryType.SparkJobPythonEntry;
        }

        /// <summary> Initializes a new instance of <see cref="SparkJobPythonEntry"/>. </summary>
        /// <param name="sparkJobEntryType"> [Required] Type of the job's entry point. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="file"> [Required] Relative python file path for job entry point. </param>
        internal SparkJobPythonEntry(SparkJobEntryType sparkJobEntryType, IDictionary<string, BinaryData> serializedAdditionalRawData, string file) : base(sparkJobEntryType, serializedAdditionalRawData)
        {
            File = file;
            SparkJobEntryType = sparkJobEntryType;
        }

        /// <summary> Initializes a new instance of <see cref="SparkJobPythonEntry"/> for deserialization. </summary>
        internal SparkJobPythonEntry()
        {
        }

        /// <summary> [Required] Relative python file path for job entry point. </summary>
        [WirePath("file")]
        public string File { get; set; }
    }
}
