// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Service Tag Outbound Rule for the managed network of a machine learning workspace. </summary>
    public partial class ServiceTagOutboundRule : MachineLearningOutboundRule
    {
        /// <summary> Initializes a new instance of <see cref="ServiceTagOutboundRule"/>. </summary>
        public ServiceTagOutboundRule()
        {
            OutboundRuleType = OutboundRuleType.ServiceTag;
        }

        /// <summary> Initializes a new instance of <see cref="ServiceTagOutboundRule"/>. </summary>
        /// <param name="category"> Category of a managed network Outbound Rule of a machine learning workspace. </param>
        /// <param name="status"> Type of a managed network Outbound Rule of a machine learning workspace. </param>
        /// <param name="outboundRuleType"> Type of a managed network Outbound Rule of a machine learning workspace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="destination"> Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace. </param>
        internal ServiceTagOutboundRule(OutboundRuleCategory? category, OutboundRuleStatus? status, OutboundRuleType outboundRuleType, IDictionary<string, BinaryData> serializedAdditionalRawData, ServiceTagDestination destination) : base(category, status, outboundRuleType, serializedAdditionalRawData)
        {
            Destination = destination;
            OutboundRuleType = outboundRuleType;
        }

        /// <summary> Service Tag destination for a Service Tag Outbound Rule for the managed network of a machine learning workspace. </summary>
        [WirePath("destination")]
        public ServiceTagDestination Destination { get; set; }
    }
}
