// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The ServerlessInferenceEndpoint. </summary>
    public partial class ServerlessInferenceEndpoint
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServerlessInferenceEndpoint"/>. </summary>
        /// <param name="uri"> [Required] The inference uri to target when making requests against the Serverless Endpoint. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        internal ServerlessInferenceEndpoint(Uri uri)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            Uri = uri;
            Headers = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="ServerlessInferenceEndpoint"/>. </summary>
        /// <param name="uri"> [Required] The inference uri to target when making requests against the Serverless Endpoint. </param>
        /// <param name="headers"> Specifies any required headers to target this serverless endpoint. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServerlessInferenceEndpoint(Uri uri, IReadOnlyDictionary<string, string> headers, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Uri = uri;
            Headers = headers;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ServerlessInferenceEndpoint"/> for deserialization. </summary>
        internal ServerlessInferenceEndpoint()
        {
        }

        /// <summary> [Required] The inference uri to target when making requests against the Serverless Endpoint. </summary>
        [WirePath("uri")]
        public Uri Uri { get; }
        /// <summary> Specifies any required headers to target this serverless endpoint. </summary>
        [WirePath("headers")]
        public IReadOnlyDictionary<string, string> Headers { get; }
    }
}
