// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> State of the Serverless Endpoint. </summary>
    public readonly partial struct ServerlessEndpointState : IEquatable<ServerlessEndpointState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServerlessEndpointState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServerlessEndpointState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string SuspendingValue = "Suspending";
        private const string ReinstatingValue = "Reinstating";
        private const string OnlineValue = "Online";
        private const string SuspendedValue = "Suspended";
        private const string CreationFailedValue = "CreationFailed";
        private const string DeletionFailedValue = "DeletionFailed";

        /// <summary> Unknown. </summary>
        public static ServerlessEndpointState Unknown { get; } = new ServerlessEndpointState(UnknownValue);
        /// <summary> Creating. </summary>
        public static ServerlessEndpointState Creating { get; } = new ServerlessEndpointState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static ServerlessEndpointState Deleting { get; } = new ServerlessEndpointState(DeletingValue);
        /// <summary> Suspending. </summary>
        public static ServerlessEndpointState Suspending { get; } = new ServerlessEndpointState(SuspendingValue);
        /// <summary> Reinstating. </summary>
        public static ServerlessEndpointState Reinstating { get; } = new ServerlessEndpointState(ReinstatingValue);
        /// <summary> Online. </summary>
        public static ServerlessEndpointState Online { get; } = new ServerlessEndpointState(OnlineValue);
        /// <summary> Suspended. </summary>
        public static ServerlessEndpointState Suspended { get; } = new ServerlessEndpointState(SuspendedValue);
        /// <summary> CreationFailed. </summary>
        public static ServerlessEndpointState CreationFailed { get; } = new ServerlessEndpointState(CreationFailedValue);
        /// <summary> DeletionFailed. </summary>
        public static ServerlessEndpointState DeletionFailed { get; } = new ServerlessEndpointState(DeletionFailedValue);
        /// <summary> Determines if two <see cref="ServerlessEndpointState"/> values are the same. </summary>
        public static bool operator ==(ServerlessEndpointState left, ServerlessEndpointState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServerlessEndpointState"/> values are not the same. </summary>
        public static bool operator !=(ServerlessEndpointState left, ServerlessEndpointState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServerlessEndpointState"/>. </summary>
        public static implicit operator ServerlessEndpointState(string value) => new ServerlessEndpointState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServerlessEndpointState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServerlessEndpointState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
