// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The ServerlessEndpointProperties. </summary>
    public partial class ServerlessEndpointProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServerlessEndpointProperties"/>. </summary>
        /// <param name="authMode"> [Required] Specifies the authentication mode for the Serverless endpoint. </param>
        public ServerlessEndpointProperties(ServerlessInferenceEndpointAuthMode authMode)
        {
            AuthMode = authMode;
        }

        /// <summary> Initializes a new instance of <see cref="ServerlessEndpointProperties"/>. </summary>
        /// <param name="modelSettings"> The model settings (model id) for the model being serviced on the ServerlessEndpoint. </param>
        /// <param name="authMode"> [Required] Specifies the authentication mode for the Serverless endpoint. </param>
        /// <param name="inferenceEndpoint"> The inference uri to target when making requests against the serverless endpoint. </param>
        /// <param name="provisioningState"> Provisioning state for the endpoint. </param>
        /// <param name="endpointState"> The current state of the ServerlessEndpoint. </param>
        /// <param name="marketplaceSubscriptionId"> The MarketplaceSubscription Azure ID associated to this ServerlessEndpoint. </param>
        /// <param name="contentSafety"> Specifies the content safety options. If omitted, the default content safety settings will be configured. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServerlessEndpointProperties(ModelSettings modelSettings, ServerlessInferenceEndpointAuthMode authMode, ServerlessInferenceEndpoint inferenceEndpoint, MachineLearningEndpointProvisioningState? provisioningState, ServerlessEndpointState? endpointState, string marketplaceSubscriptionId, ContentSafety contentSafety, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ModelSettings = modelSettings;
            AuthMode = authMode;
            InferenceEndpoint = inferenceEndpoint;
            ProvisioningState = provisioningState;
            EndpointState = endpointState;
            MarketplaceSubscriptionId = marketplaceSubscriptionId;
            ContentSafety = contentSafety;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ServerlessEndpointProperties"/> for deserialization. </summary>
        internal ServerlessEndpointProperties()
        {
        }

        /// <summary> The model settings (model id) for the model being serviced on the ServerlessEndpoint. </summary>
        internal ModelSettings ModelSettings { get; set; }
        /// <summary> The unique model identifier that this ServerlessEndpoint should provision. </summary>
        [WirePath("modelSettings.modelId")]
        public string ModelId
        {
            get => ModelSettings is null ? default : ModelSettings.ModelId;
            set
            {
                if (ModelSettings is null)
                    ModelSettings = new ModelSettings();
                ModelSettings.ModelId = value;
            }
        }

        /// <summary> [Required] Specifies the authentication mode for the Serverless endpoint. </summary>
        [WirePath("authMode")]
        public ServerlessInferenceEndpointAuthMode AuthMode { get; set; }
        /// <summary> The inference uri to target when making requests against the serverless endpoint. </summary>
        [WirePath("inferenceEndpoint")]
        public ServerlessInferenceEndpoint InferenceEndpoint { get; }
        /// <summary> Provisioning state for the endpoint. </summary>
        [WirePath("provisioningState")]
        public MachineLearningEndpointProvisioningState? ProvisioningState { get; }
        /// <summary> The current state of the ServerlessEndpoint. </summary>
        [WirePath("endpointState")]
        public ServerlessEndpointState? EndpointState { get; }
        /// <summary> The MarketplaceSubscription Azure ID associated to this ServerlessEndpoint. </summary>
        [WirePath("marketplaceSubscriptionId")]
        public string MarketplaceSubscriptionId { get; }
        /// <summary> Specifies the content safety options. If omitted, the default content safety settings will be configured. </summary>
        internal ContentSafety ContentSafety { get; set; }
        /// <summary> [Required] Specifies the status of content safety. </summary>
        [WirePath("contentSafety.contentSafetyStatus")]
        public ContentSafetyStatus? ContentSafetyStatus
        {
            get => ContentSafety is null ? default(ContentSafetyStatus?) : ContentSafety.ContentSafetyStatus;
            set
            {
                ContentSafety = value.HasValue ? new ContentSafety(value.Value) : null;
            }
        }
    }
}
