// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class ServerlessEndpointProperties : IUtf8JsonSerializable, IJsonModel<ServerlessEndpointProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServerlessEndpointProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServerlessEndpointProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessEndpointProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerlessEndpointProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ModelSettings))
            {
                if (ModelSettings != null)
                {
                    writer.WritePropertyName("modelSettings"u8);
                    writer.WriteObjectValue(ModelSettings, options);
                }
                else
                {
                    writer.WriteNull("modelSettings");
                }
            }
            writer.WritePropertyName("authMode"u8);
            writer.WriteStringValue(AuthMode.ToString());
            if (options.Format != "W" && Optional.IsDefined(InferenceEndpoint))
            {
                if (InferenceEndpoint != null)
                {
                    writer.WritePropertyName("inferenceEndpoint"u8);
                    writer.WriteObjectValue(InferenceEndpoint, options);
                }
                else
                {
                    writer.WriteNull("inferenceEndpoint");
                }
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(EndpointState))
            {
                writer.WritePropertyName("endpointState"u8);
                writer.WriteStringValue(EndpointState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(MarketplaceSubscriptionId))
            {
                if (MarketplaceSubscriptionId != null)
                {
                    writer.WritePropertyName("marketplaceSubscriptionId"u8);
                    writer.WriteStringValue(MarketplaceSubscriptionId);
                }
                else
                {
                    writer.WriteNull("marketplaceSubscriptionId");
                }
            }
            if (Optional.IsDefined(ContentSafety))
            {
                if (ContentSafety != null)
                {
                    writer.WritePropertyName("contentSafety"u8);
                    writer.WriteObjectValue(ContentSafety, options);
                }
                else
                {
                    writer.WriteNull("contentSafety");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServerlessEndpointProperties IJsonModel<ServerlessEndpointProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessEndpointProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerlessEndpointProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServerlessEndpointProperties(document.RootElement, options);
        }

        internal static ServerlessEndpointProperties DeserializeServerlessEndpointProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ModelSettings modelSettings = default;
            ServerlessInferenceEndpointAuthMode authMode = default;
            ServerlessInferenceEndpoint inferenceEndpoint = default;
            MachineLearningEndpointProvisioningState? provisioningState = default;
            ServerlessEndpointState? endpointState = default;
            string marketplaceSubscriptionId = default;
            ContentSafety contentSafety = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("modelSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        modelSettings = null;
                        continue;
                    }
                    modelSettings = ModelSettings.DeserializeModelSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("authMode"u8))
                {
                    authMode = new ServerlessInferenceEndpointAuthMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("inferenceEndpoint"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        inferenceEndpoint = null;
                        continue;
                    }
                    inferenceEndpoint = ServerlessInferenceEndpoint.DeserializeServerlessInferenceEndpoint(property.Value, options);
                    continue;
                }
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new MachineLearningEndpointProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("endpointState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endpointState = new ServerlessEndpointState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("marketplaceSubscriptionId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        marketplaceSubscriptionId = null;
                        continue;
                    }
                    marketplaceSubscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("contentSafety"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        contentSafety = null;
                        continue;
                    }
                    contentSafety = ContentSafety.DeserializeContentSafety(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServerlessEndpointProperties(
                modelSettings,
                authMode,
                inferenceEndpoint,
                provisioningState,
                endpointState,
                marketplaceSubscriptionId,
                contentSafety,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("ModelId", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  modelSettings: ");
                builder.AppendLine("{");
                builder.Append("    modelId: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(ModelSettings))
                {
                    builder.Append("  modelSettings: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ModelSettings, options, 2, false, "  modelSettings: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  authMode: ");
                builder.AppendLine($"'{AuthMode.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InferenceEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  inferenceEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InferenceEndpoint))
                {
                    builder.Append("  inferenceEndpoint: ");
                    BicepSerializationHelpers.AppendChildObject(builder, InferenceEndpoint, options, 2, false, "  inferenceEndpoint: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("  provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EndpointState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  endpointState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EndpointState))
                {
                    builder.Append("  endpointState: ");
                    builder.AppendLine($"'{EndpointState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MarketplaceSubscriptionId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  marketplaceSubscriptionId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MarketplaceSubscriptionId))
                {
                    builder.Append("  marketplaceSubscriptionId: ");
                    if (MarketplaceSubscriptionId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MarketplaceSubscriptionId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MarketplaceSubscriptionId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("ContentSafetyStatus", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  contentSafety: ");
                builder.AppendLine("{");
                builder.Append("    contentSafetyStatus: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("  }");
            }
            else
            {
                if (Optional.IsDefined(ContentSafety))
                {
                    builder.Append("  contentSafety: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ContentSafety, options, 2, false, "  contentSafety: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ServerlessEndpointProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessEndpointProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ServerlessEndpointProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ServerlessEndpointProperties IPersistableModel<ServerlessEndpointProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerlessEndpointProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServerlessEndpointProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServerlessEndpointProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServerlessEndpointProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
