// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Forecasting seasonality mode. </summary>
    internal readonly partial struct SeasonalityMode : IEquatable<SeasonalityMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SeasonalityMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SeasonalityMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoValue = "Auto";
        private const string CustomValue = "Custom";

        /// <summary> Seasonality to be determined automatically. </summary>
        public static SeasonalityMode Auto { get; } = new SeasonalityMode(AutoValue);
        /// <summary> Use the custom seasonality value. </summary>
        public static SeasonalityMode Custom { get; } = new SeasonalityMode(CustomValue);
        /// <summary> Determines if two <see cref="SeasonalityMode"/> values are the same. </summary>
        public static bool operator ==(SeasonalityMode left, SeasonalityMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SeasonalityMode"/> values are not the same. </summary>
        public static bool operator !=(SeasonalityMode left, SeasonalityMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SeasonalityMode"/>. </summary>
        public static implicit operator SeasonalityMode(string value) => new SeasonalityMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SeasonalityMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SeasonalityMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
