// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The ScheduleActionType. </summary>
    internal readonly partial struct ScheduleActionType : IEquatable<ScheduleActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScheduleActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScheduleActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreateJobValue = "CreateJob";
        private const string InvokeBatchEndpointValue = "InvokeBatchEndpoint";
        private const string CreateMonitorValue = "CreateMonitor";

        /// <summary> CreateJob. </summary>
        public static ScheduleActionType CreateJob { get; } = new ScheduleActionType(CreateJobValue);
        /// <summary> InvokeBatchEndpoint. </summary>
        public static ScheduleActionType InvokeBatchEndpoint { get; } = new ScheduleActionType(InvokeBatchEndpointValue);
        /// <summary> CreateMonitor. </summary>
        public static ScheduleActionType CreateMonitor { get; } = new ScheduleActionType(CreateMonitorValue);
        /// <summary> Determines if two <see cref="ScheduleActionType"/> values are the same. </summary>
        public static bool operator ==(ScheduleActionType left, ScheduleActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScheduleActionType"/> values are not the same. </summary>
        public static bool operator !=(ScheduleActionType left, ScheduleActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScheduleActionType"/>. </summary>
        public static implicit operator ScheduleActionType(string value) => new ScheduleActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScheduleActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScheduleActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
