// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The ScaleType. </summary>
    internal readonly partial struct ScaleType : IEquatable<ScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string TargetUtilizationValue = "TargetUtilization";

        /// <summary> Default. </summary>
        public static ScaleType Default { get; } = new ScaleType(DefaultValue);
        /// <summary> TargetUtilization. </summary>
        public static ScaleType TargetUtilization { get; } = new ScaleType(TargetUtilizationValue);
        /// <summary> Determines if two <see cref="ScaleType"/> values are the same. </summary>
        public static bool operator ==(ScaleType left, ScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScaleType"/> values are not the same. </summary>
        public static bool operator !=(ScaleType left, ScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScaleType"/>. </summary>
        public static implicit operator ScaleType(string value) => new ScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
