// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The SamplingAlgorithmType. </summary>
    public readonly partial struct SamplingAlgorithmType : IEquatable<SamplingAlgorithmType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SamplingAlgorithmType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SamplingAlgorithmType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GridValue = "Grid";
        private const string RandomValue = "Random";
        private const string BayesianValue = "Bayesian";

        /// <summary> Grid. </summary>
        public static SamplingAlgorithmType Grid { get; } = new SamplingAlgorithmType(GridValue);
        /// <summary> Random. </summary>
        public static SamplingAlgorithmType Random { get; } = new SamplingAlgorithmType(RandomValue);
        /// <summary> Bayesian. </summary>
        public static SamplingAlgorithmType Bayesian { get; } = new SamplingAlgorithmType(BayesianValue);
        /// <summary> Determines if two <see cref="SamplingAlgorithmType"/> values are the same. </summary>
        public static bool operator ==(SamplingAlgorithmType left, SamplingAlgorithmType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SamplingAlgorithmType"/> values are not the same. </summary>
        public static bool operator !=(SamplingAlgorithmType left, SamplingAlgorithmType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SamplingAlgorithmType"/>. </summary>
        public static implicit operator SamplingAlgorithmType(string value) => new SamplingAlgorithmType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SamplingAlgorithmType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SamplingAlgorithmType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
