// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The RollingRateType. </summary>
    public readonly partial struct RollingRateType : IEquatable<RollingRateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RollingRateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RollingRateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string YearValue = "Year";
        private const string MonthValue = "Month";
        private const string DayValue = "Day";
        private const string HourValue = "Hour";
        private const string MinuteValue = "Minute";

        /// <summary> Year. </summary>
        public static RollingRateType Year { get; } = new RollingRateType(YearValue);
        /// <summary> Month. </summary>
        public static RollingRateType Month { get; } = new RollingRateType(MonthValue);
        /// <summary> Day. </summary>
        public static RollingRateType Day { get; } = new RollingRateType(DayValue);
        /// <summary> Hour. </summary>
        public static RollingRateType Hour { get; } = new RollingRateType(HourValue);
        /// <summary> Minute. </summary>
        public static RollingRateType Minute { get; } = new RollingRateType(MinuteValue);
        /// <summary> Determines if two <see cref="RollingRateType"/> values are the same. </summary>
        public static bool operator ==(RollingRateType left, RollingRateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RollingRateType"/> values are not the same. </summary>
        public static bool operator !=(RollingRateType left, RollingRateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RollingRateType"/>. </summary>
        public static implicit operator RollingRateType(string value) => new RollingRateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RollingRateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RollingRateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
