// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Rolling input data definition. </summary>
    public partial class RollingInputData : MonitoringInputDataBase
    {
        /// <summary> Initializes a new instance of <see cref="RollingInputData"/>. </summary>
        /// <param name="jobInputType"> [Required] Specifies the type of job. </param>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <param name="windowOffset"> [Required] The time offset between the end of the data window and the monitor's current run time. </param>
        /// <param name="windowSize"> [Required] The size of the rolling data window. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="uri"/> is null. </exception>
        public RollingInputData(JobInputType jobInputType, Uri uri, TimeSpan windowOffset, TimeSpan windowSize) : base(jobInputType, uri)
        {
            Argument.AssertNotNull(uri, nameof(uri));

            WindowOffset = windowOffset;
            WindowSize = windowSize;
            InputDataType = MonitoringInputDataType.Rolling;
        }

        /// <summary> Initializes a new instance of <see cref="RollingInputData"/>. </summary>
        /// <param name="inputDataType"> [Required] Specifies the type of signal to monitor. </param>
        /// <param name="dataContext"> The context metadata of the data source. </param>
        /// <param name="jobInputType"> [Required] Specifies the type of job. </param>
        /// <param name="uri"> [Required] Input Asset URI. </param>
        /// <param name="columns"> Mapping of column names to special uses. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="windowOffset"> [Required] The time offset between the end of the data window and the monitor's current run time. </param>
        /// <param name="windowSize"> [Required] The size of the rolling data window. </param>
        /// <param name="preprocessingComponentId"> Reference to the component asset used to preprocess the data. </param>
        internal RollingInputData(MonitoringInputDataType inputDataType, string dataContext, JobInputType jobInputType, Uri uri, IDictionary<string, string> columns, IDictionary<string, BinaryData> serializedAdditionalRawData, TimeSpan windowOffset, TimeSpan windowSize, string preprocessingComponentId) : base(inputDataType, dataContext, jobInputType, uri, columns, serializedAdditionalRawData)
        {
            WindowOffset = windowOffset;
            WindowSize = windowSize;
            PreprocessingComponentId = preprocessingComponentId;
            InputDataType = inputDataType;
        }

        /// <summary> Initializes a new instance of <see cref="RollingInputData"/> for deserialization. </summary>
        internal RollingInputData()
        {
        }

        /// <summary> [Required] The time offset between the end of the data window and the monitor's current run time. </summary>
        [WirePath("windowOffset")]
        public TimeSpan WindowOffset { get; set; }
        /// <summary> [Required] The size of the rolling data window. </summary>
        [WirePath("windowSize")]
        public TimeSpan WindowSize { get; set; }
        /// <summary> Reference to the component asset used to preprocess the data. </summary>
        [WirePath("preprocessingComponentId")]
        public string PreprocessingComponentId { get; set; }
    }
}
