// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class RollingInputData : IUtf8JsonSerializable, IJsonModel<RollingInputData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RollingInputData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RollingInputData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RollingInputData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RollingInputData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("windowOffset"u8);
            writer.WriteStringValue(WindowOffset, "P");
            writer.WritePropertyName("windowSize"u8);
            writer.WriteStringValue(WindowSize, "P");
            if (Optional.IsDefined(PreprocessingComponentId))
            {
                if (PreprocessingComponentId != null)
                {
                    writer.WritePropertyName("preprocessingComponentId"u8);
                    writer.WriteStringValue(PreprocessingComponentId);
                }
                else
                {
                    writer.WriteNull("preprocessingComponentId");
                }
            }
        }

        RollingInputData IJsonModel<RollingInputData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RollingInputData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RollingInputData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRollingInputData(document.RootElement, options);
        }

        internal static RollingInputData DeserializeRollingInputData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            TimeSpan windowOffset = default;
            TimeSpan windowSize = default;
            string preprocessingComponentId = default;
            MonitoringInputDataType inputDataType = default;
            string dataContext = default;
            JobInputType jobInputType = default;
            Uri uri = default;
            IDictionary<string, string> columns = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("windowOffset"u8))
                {
                    windowOffset = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("windowSize"u8))
                {
                    windowSize = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("preprocessingComponentId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        preprocessingComponentId = null;
                        continue;
                    }
                    preprocessingComponentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("inputDataType"u8))
                {
                    inputDataType = new MonitoringInputDataType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dataContext"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        dataContext = null;
                        continue;
                    }
                    dataContext = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("jobInputType"u8))
                {
                    jobInputType = new JobInputType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("uri"u8))
                {
                    uri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("columns"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        columns = null;
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    columns = dictionary;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RollingInputData(
                inputDataType,
                dataContext,
                jobInputType,
                uri,
                columns ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData,
                windowOffset,
                windowSize,
                preprocessingComponentId);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WindowOffset), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  windowOffset: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  windowOffset: ");
                var formattedTimeSpan = TypeFormatters.ToString(WindowOffset, "P");
                builder.AppendLine($"'{formattedTimeSpan}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WindowSize), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  windowSize: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  windowSize: ");
                var formattedTimeSpan = TypeFormatters.ToString(WindowSize, "P");
                builder.AppendLine($"'{formattedTimeSpan}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PreprocessingComponentId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  preprocessingComponentId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PreprocessingComponentId))
                {
                    builder.Append("  preprocessingComponentId: ");
                    if (PreprocessingComponentId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PreprocessingComponentId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PreprocessingComponentId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InputDataType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  inputDataType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  inputDataType: ");
                builder.AppendLine($"'{InputDataType.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataContext), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataContext: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataContext))
                {
                    builder.Append("  dataContext: ");
                    if (DataContext.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DataContext}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DataContext}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(JobInputType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  jobInputType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  jobInputType: ");
                builder.AppendLine($"'{JobInputType.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Uri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  uri: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Uri))
                {
                    builder.Append("  uri: ");
                    builder.AppendLine($"'{Uri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Columns), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  columns: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Columns))
                {
                    if (Columns.Any())
                    {
                        builder.Append("  columns: ");
                        builder.AppendLine("{");
                        foreach (var item in Columns)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RollingInputData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RollingInputData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RollingInputData)} does not support writing '{options.Format}' format.");
            }
        }

        RollingInputData IPersistableModel<RollingInputData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RollingInputData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRollingInputData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RollingInputData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RollingInputData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
