// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Provisioning state of registry asset. </summary>
    public readonly partial struct RegistryAssetProvisioningState : IEquatable<RegistryAssetProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RegistryAssetProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RegistryAssetProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";

        /// <summary> Succeeded. </summary>
        public static RegistryAssetProvisioningState Succeeded { get; } = new RegistryAssetProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static RegistryAssetProvisioningState Failed { get; } = new RegistryAssetProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static RegistryAssetProvisioningState Canceled { get; } = new RegistryAssetProvisioningState(CanceledValue);
        /// <summary> Creating. </summary>
        public static RegistryAssetProvisioningState Creating { get; } = new RegistryAssetProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static RegistryAssetProvisioningState Updating { get; } = new RegistryAssetProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static RegistryAssetProvisioningState Deleting { get; } = new RegistryAssetProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="RegistryAssetProvisioningState"/> values are the same. </summary>
        public static bool operator ==(RegistryAssetProvisioningState left, RegistryAssetProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RegistryAssetProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(RegistryAssetProvisioningState left, RegistryAssetProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RegistryAssetProvisioningState"/>. </summary>
        public static implicit operator RegistryAssetProvisioningState(string value) => new RegistryAssetProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RegistryAssetProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RegistryAssetProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
