// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The specific type of random algorithm. </summary>
    public readonly partial struct RandomSamplingAlgorithmRule : IEquatable<RandomSamplingAlgorithmRule>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RandomSamplingAlgorithmRule"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RandomSamplingAlgorithmRule(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RandomValue = "Random";
        private const string SobolValue = "Sobol";

        /// <summary> Random. </summary>
        public static RandomSamplingAlgorithmRule Random { get; } = new RandomSamplingAlgorithmRule(RandomValue);
        /// <summary> Sobol. </summary>
        public static RandomSamplingAlgorithmRule Sobol { get; } = new RandomSamplingAlgorithmRule(SobolValue);
        /// <summary> Determines if two <see cref="RandomSamplingAlgorithmRule"/> values are the same. </summary>
        public static bool operator ==(RandomSamplingAlgorithmRule left, RandomSamplingAlgorithmRule right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RandomSamplingAlgorithmRule"/> values are not the same. </summary>
        public static bool operator !=(RandomSamplingAlgorithmRule left, RandomSamplingAlgorithmRule right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RandomSamplingAlgorithmRule"/>. </summary>
        public static implicit operator RandomSamplingAlgorithmRule(string value) => new RandomSamplingAlgorithmRule(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RandomSamplingAlgorithmRule other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RandomSamplingAlgorithmRule other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
