// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Private Endpoint destination for a Private Endpoint Outbound Rule for the managed network of a machine learning workspace. </summary>
    public partial class PrivateEndpointDestination
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PrivateEndpointDestination"/>. </summary>
        public PrivateEndpointDestination()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PrivateEndpointDestination"/>. </summary>
        /// <param name="serviceResourceId"></param>
        /// <param name="sparkEnabled"></param>
        /// <param name="sparkStatus"> Type of a managed network Outbound Rule of a machine learning workspace. </param>
        /// <param name="subresourceTarget"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PrivateEndpointDestination(ResourceIdentifier serviceResourceId, bool? sparkEnabled, OutboundRuleStatus? sparkStatus, string subresourceTarget, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceResourceId = serviceResourceId;
            SparkEnabled = sparkEnabled;
            SparkStatus = sparkStatus;
            SubresourceTarget = subresourceTarget;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the service resource id. </summary>
        [WirePath("serviceResourceId")]
        public ResourceIdentifier ServiceResourceId { get; set; }
        /// <summary> Gets or sets the spark enabled. </summary>
        [WirePath("sparkEnabled")]
        public bool? SparkEnabled { get; set; }
        /// <summary> Type of a managed network Outbound Rule of a machine learning workspace. </summary>
        [WirePath("sparkStatus")]
        public OutboundRuleStatus? SparkStatus { get; set; }
        /// <summary> Gets or sets the subresource target. </summary>
        [WirePath("subresourceTarget")]
        public string SubresourceTarget { get; set; }
    }
}
