// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Type of storage to use for the pending upload location. </summary>
    public readonly partial struct PendingUploadType : IEquatable<PendingUploadType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PendingUploadType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PendingUploadType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string TemporaryBlobReferenceValue = "TemporaryBlobReference";

        /// <summary> None. </summary>
        public static PendingUploadType None { get; } = new PendingUploadType(NoneValue);
        /// <summary> TemporaryBlobReference. </summary>
        public static PendingUploadType TemporaryBlobReference { get; } = new PendingUploadType(TemporaryBlobReferenceValue);
        /// <summary> Determines if two <see cref="PendingUploadType"/> values are the same. </summary>
        public static bool operator ==(PendingUploadType left, PendingUploadType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PendingUploadType"/> values are not the same. </summary>
        public static bool operator !=(PendingUploadType left, PendingUploadType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PendingUploadType"/>. </summary>
        public static implicit operator PendingUploadType(string value) => new PendingUploadType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PendingUploadType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PendingUploadType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
