// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The PendingUploadResponseDto. </summary>
    public partial class PendingUploadResponseDto
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PendingUploadResponseDto"/>. </summary>
        internal PendingUploadResponseDto()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PendingUploadResponseDto"/>. </summary>
        /// <param name="blobReferenceForConsumption"> Container level read, write, list SAS. </param>
        /// <param name="pendingUploadId"> ID for this upload request. </param>
        /// <param name="pendingUploadType"> TemporaryBlobReference is the only supported type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PendingUploadResponseDto(BlobReferenceForConsumptionDto blobReferenceForConsumption, string pendingUploadId, PendingUploadType? pendingUploadType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BlobReferenceForConsumption = blobReferenceForConsumption;
            PendingUploadId = pendingUploadId;
            PendingUploadType = pendingUploadType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Container level read, write, list SAS. </summary>
        [WirePath("blobReferenceForConsumption")]
        public BlobReferenceForConsumptionDto BlobReferenceForConsumption { get; }
        /// <summary> ID for this upload request. </summary>
        [WirePath("pendingUploadId")]
        public string PendingUploadId { get; }
        /// <summary> TemporaryBlobReference is the only supported type. </summary>
        [WirePath("pendingUploadType")]
        public PendingUploadType? PendingUploadType { get; }
    }
}
