// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class PendingUploadResponseDto : IUtf8JsonSerializable, IJsonModel<PendingUploadResponseDto>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PendingUploadResponseDto>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PendingUploadResponseDto>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PendingUploadResponseDto>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PendingUploadResponseDto)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(BlobReferenceForConsumption))
            {
                if (BlobReferenceForConsumption != null)
                {
                    writer.WritePropertyName("blobReferenceForConsumption"u8);
                    writer.WriteObjectValue(BlobReferenceForConsumption, options);
                }
                else
                {
                    writer.WriteNull("blobReferenceForConsumption");
                }
            }
            if (Optional.IsDefined(PendingUploadId))
            {
                if (PendingUploadId != null)
                {
                    writer.WritePropertyName("pendingUploadId"u8);
                    writer.WriteStringValue(PendingUploadId);
                }
                else
                {
                    writer.WriteNull("pendingUploadId");
                }
            }
            if (Optional.IsDefined(PendingUploadType))
            {
                writer.WritePropertyName("pendingUploadType"u8);
                writer.WriteStringValue(PendingUploadType.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PendingUploadResponseDto IJsonModel<PendingUploadResponseDto>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PendingUploadResponseDto>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PendingUploadResponseDto)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePendingUploadResponseDto(document.RootElement, options);
        }

        internal static PendingUploadResponseDto DeserializePendingUploadResponseDto(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BlobReferenceForConsumptionDto blobReferenceForConsumption = default;
            string pendingUploadId = default;
            PendingUploadType? pendingUploadType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("blobReferenceForConsumption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        blobReferenceForConsumption = null;
                        continue;
                    }
                    blobReferenceForConsumption = BlobReferenceForConsumptionDto.DeserializeBlobReferenceForConsumptionDto(property.Value, options);
                    continue;
                }
                if (property.NameEquals("pendingUploadId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        pendingUploadId = null;
                        continue;
                    }
                    pendingUploadId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("pendingUploadType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pendingUploadType = new PendingUploadType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PendingUploadResponseDto(blobReferenceForConsumption, pendingUploadId, pendingUploadType, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BlobReferenceForConsumption), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  blobReferenceForConsumption: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BlobReferenceForConsumption))
                {
                    builder.Append("  blobReferenceForConsumption: ");
                    BicepSerializationHelpers.AppendChildObject(builder, BlobReferenceForConsumption, options, 2, false, "  blobReferenceForConsumption: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PendingUploadId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  pendingUploadId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PendingUploadId))
                {
                    builder.Append("  pendingUploadId: ");
                    if (PendingUploadId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PendingUploadId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PendingUploadId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PendingUploadType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  pendingUploadType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PendingUploadType))
                {
                    builder.Append("  pendingUploadType: ");
                    builder.AppendLine($"'{PendingUploadType.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PendingUploadResponseDto>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PendingUploadResponseDto>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PendingUploadResponseDto)} does not support writing '{options.Format}' format.");
            }
        }

        PendingUploadResponseDto IPersistableModel<PendingUploadResponseDto>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PendingUploadResponseDto>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePendingUploadResponseDto(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PendingUploadResponseDto)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PendingUploadResponseDto>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
