// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The PendingUploadRequestDto. </summary>
    public partial class PendingUploadRequestDto
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PendingUploadRequestDto"/>. </summary>
        public PendingUploadRequestDto()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PendingUploadRequestDto"/>. </summary>
        /// <param name="pendingUploadId"> If PendingUploadId = null then random guid will be used. </param>
        /// <param name="pendingUploadType"> TemporaryBlobReference is the only supported type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PendingUploadRequestDto(string pendingUploadId, PendingUploadType? pendingUploadType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PendingUploadId = pendingUploadId;
            PendingUploadType = pendingUploadType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> If PendingUploadId = null then random guid will be used. </summary>
        [WirePath("pendingUploadId")]
        public string PendingUploadId { get; set; }
        /// <summary> TemporaryBlobReference is the only supported type. </summary>
        [WirePath("pendingUploadType")]
        public PendingUploadType? PendingUploadType { get; set; }
    }
}
