// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Type of a managed network Outbound Rule of a machine learning workspace. </summary>
    internal readonly partial struct OutboundRuleType : IEquatable<OutboundRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OutboundRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OutboundRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FqdnValue = "FQDN";
        private const string PrivateEndpointValue = "PrivateEndpoint";
        private const string ServiceTagValue = "ServiceTag";

        /// <summary> FQDN. </summary>
        public static OutboundRuleType Fqdn { get; } = new OutboundRuleType(FqdnValue);
        /// <summary> PrivateEndpoint. </summary>
        public static OutboundRuleType PrivateEndpoint { get; } = new OutboundRuleType(PrivateEndpointValue);
        /// <summary> ServiceTag. </summary>
        public static OutboundRuleType ServiceTag { get; } = new OutboundRuleType(ServiceTagValue);
        /// <summary> Determines if two <see cref="OutboundRuleType"/> values are the same. </summary>
        public static bool operator ==(OutboundRuleType left, OutboundRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OutboundRuleType"/> values are not the same. </summary>
        public static bool operator !=(OutboundRuleType left, OutboundRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OutboundRuleType"/>. </summary>
        public static implicit operator OutboundRuleType(string value) => new OutboundRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OutboundRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OutboundRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
