// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine OneLake artifact type. </summary>
    internal readonly partial struct OneLakeArtifactType : IEquatable<OneLakeArtifactType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OneLakeArtifactType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OneLakeArtifactType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LakeHouseValue = "LakeHouse";

        /// <summary> LakeHouse. </summary>
        public static OneLakeArtifactType LakeHouse { get; } = new OneLakeArtifactType(LakeHouseValue);
        /// <summary> Determines if two <see cref="OneLakeArtifactType"/> values are the same. </summary>
        public static bool operator ==(OneLakeArtifactType left, OneLakeArtifactType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OneLakeArtifactType"/> values are not the same. </summary>
        public static bool operator !=(OneLakeArtifactType left, OneLakeArtifactType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OneLakeArtifactType"/>. </summary>
        public static implicit operator OneLakeArtifactType(string value) => new OneLakeArtifactType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OneLakeArtifactType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OneLakeArtifactType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
