// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary>
    /// OneLake artifact (data source) configuration.
    /// Please note <see cref="OneLakeArtifact"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="LakeHouseArtifact"/>.
    /// </summary>
    public abstract partial class OneLakeArtifact
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OneLakeArtifact"/>. </summary>
        /// <param name="artifactName"> [Required] OneLake artifact name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="artifactName"/> is null. </exception>
        protected OneLakeArtifact(string artifactName)
        {
            Argument.AssertNotNull(artifactName, nameof(artifactName));

            ArtifactName = artifactName;
        }

        /// <summary> Initializes a new instance of <see cref="OneLakeArtifact"/>. </summary>
        /// <param name="artifactType"> [Required] OneLake artifact type. </param>
        /// <param name="artifactName"> [Required] OneLake artifact name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OneLakeArtifact(OneLakeArtifactType artifactType, string artifactName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ArtifactType = artifactType;
            ArtifactName = artifactName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="OneLakeArtifact"/> for deserialization. </summary>
        internal OneLakeArtifact()
        {
        }

        /// <summary> [Required] OneLake artifact type. </summary>
        internal OneLakeArtifactType ArtifactType { get; set; }
        /// <summary> [Required] OneLake artifact name. </summary>
        [WirePath("artifactName")]
        public string ArtifactName { get; set; }
    }
}
