// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The NumericalDataQualityMetric. </summary>
    public readonly partial struct NumericalDataQualityMetric : IEquatable<NumericalDataQualityMetric>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NumericalDataQualityMetric"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NumericalDataQualityMetric(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NullValueRateValue = "NullValueRate";
        private const string DataTypeErrorRateValue = "DataTypeErrorRate";
        private const string OutOfBoundsRateValue = "OutOfBoundsRate";

        /// <summary> Calculates the rate of null values. </summary>
        public static NumericalDataQualityMetric NullValueRate { get; } = new NumericalDataQualityMetric(NullValueRateValue);
        /// <summary> Calculates the rate of data type errors. </summary>
        public static NumericalDataQualityMetric DataTypeErrorRate { get; } = new NumericalDataQualityMetric(DataTypeErrorRateValue);
        /// <summary> Calculates the rate values are out of bounds. </summary>
        public static NumericalDataQualityMetric OutOfBoundsRate { get; } = new NumericalDataQualityMetric(OutOfBoundsRateValue);
        /// <summary> Determines if two <see cref="NumericalDataQualityMetric"/> values are the same. </summary>
        public static bool operator ==(NumericalDataQualityMetric left, NumericalDataQualityMetric right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NumericalDataQualityMetric"/> values are not the same. </summary>
        public static bool operator !=(NumericalDataQualityMetric left, NumericalDataQualityMetric right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NumericalDataQualityMetric"/>. </summary>
        public static implicit operator NumericalDataQualityMetric(string value) => new NumericalDataQualityMetric(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NumericalDataQualityMetric other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NumericalDataQualityMetric other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
