// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The NumericalDataDriftMetric. </summary>
    public readonly partial struct NumericalDataDriftMetric : IEquatable<NumericalDataDriftMetric>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NumericalDataDriftMetric"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NumericalDataDriftMetric(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JensenShannonDistanceValue = "JensenShannonDistance";
        private const string PopulationStabilityIndexValue = "PopulationStabilityIndex";
        private const string NormalizedWassersteinDistanceValue = "NormalizedWassersteinDistance";
        private const string TwoSampleKolmogorovSmirnovTestValue = "TwoSampleKolmogorovSmirnovTest";

        /// <summary> The Jensen Shannon Distance (JSD) metric. </summary>
        public static NumericalDataDriftMetric JensenShannonDistance { get; } = new NumericalDataDriftMetric(JensenShannonDistanceValue);
        /// <summary> The Population Stability Index (PSI) metric. </summary>
        public static NumericalDataDriftMetric PopulationStabilityIndex { get; } = new NumericalDataDriftMetric(PopulationStabilityIndexValue);
        /// <summary> The Normalized Wasserstein Distance metric. </summary>
        public static NumericalDataDriftMetric NormalizedWassersteinDistance { get; } = new NumericalDataDriftMetric(NormalizedWassersteinDistanceValue);
        /// <summary> The Two Sample Kolmogorov-Smirnov Test (two-sample K–S) metric. </summary>
        public static NumericalDataDriftMetric TwoSampleKolmogorovSmirnovTest { get; } = new NumericalDataDriftMetric(TwoSampleKolmogorovSmirnovTestValue);
        /// <summary> Determines if two <see cref="NumericalDataDriftMetric"/> values are the same. </summary>
        public static bool operator ==(NumericalDataDriftMetric left, NumericalDataDriftMetric right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NumericalDataDriftMetric"/> values are not the same. </summary>
        public static bool operator !=(NumericalDataDriftMetric left, NumericalDataDriftMetric right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NumericalDataDriftMetric"/>. </summary>
        public static implicit operator NumericalDataDriftMetric(string value) => new NumericalDataDriftMetric(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NumericalDataDriftMetric other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NumericalDataDriftMetric other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
