// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Configuration for notification. </summary>
    public partial class NotificationSetting
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationSetting"/>. </summary>
        public NotificationSetting()
        {
            Emails = new ChangeTrackingList<string>();
            EmailOn = new ChangeTrackingList<EmailNotificationEnableType>();
            Webhooks = new ChangeTrackingDictionary<string, MachineLearningWebhook>();
        }

        /// <summary> Initializes a new instance of <see cref="NotificationSetting"/>. </summary>
        /// <param name="emails"> This is the email recipient list which has a limitation of 499 characters in total concat with comma separator. </param>
        /// <param name="emailOn"> Send email notification to user on specified notification type. </param>
        /// <param name="webhooks">
        /// Send webhook callback to a service. Key is a user-provided name for the webhook.
        /// Please note <see cref="MachineLearningWebhook"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureDevOpsWebhook"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationSetting(IList<string> emails, IList<EmailNotificationEnableType> emailOn, IDictionary<string, MachineLearningWebhook> webhooks, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Emails = emails;
            EmailOn = emailOn;
            Webhooks = webhooks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> This is the email recipient list which has a limitation of 499 characters in total concat with comma separator. </summary>
        [WirePath("emails")]
        public IList<string> Emails { get; set; }
        /// <summary> Send email notification to user on specified notification type. </summary>
        [WirePath("emailOn")]
        public IList<EmailNotificationEnableType> EmailOn { get; set; }
        /// <summary>
        /// Send webhook callback to a service. Key is a user-provided name for the webhook.
        /// Please note <see cref="MachineLearningWebhook"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureDevOpsWebhook"/>.
        /// </summary>
        [WirePath("webhooks")]
        public IDictionary<string, MachineLearningWebhook> Webhooks { get; set; }
    }
}
