// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    public partial class NotificationSetting : IUtf8JsonSerializable, IJsonModel<NotificationSetting>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<NotificationSetting>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<NotificationSetting>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NotificationSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NotificationSetting)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(Emails))
            {
                if (Emails != null)
                {
                    writer.WritePropertyName("emails"u8);
                    writer.WriteStartArray();
                    foreach (var item in Emails)
                    {
                        writer.WriteStringValue(item);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("emails");
                }
            }
            if (Optional.IsCollectionDefined(EmailOn))
            {
                if (EmailOn != null)
                {
                    writer.WritePropertyName("emailOn"u8);
                    writer.WriteStartArray();
                    foreach (var item in EmailOn)
                    {
                        writer.WriteStringValue(item.ToString());
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("emailOn");
                }
            }
            if (Optional.IsCollectionDefined(Webhooks))
            {
                if (Webhooks != null)
                {
                    writer.WritePropertyName("webhooks"u8);
                    writer.WriteStartObject();
                    foreach (var item in Webhooks)
                    {
                        writer.WritePropertyName(item.Key);
                        writer.WriteObjectValue(item.Value, options);
                    }
                    writer.WriteEndObject();
                }
                else
                {
                    writer.WriteNull("webhooks");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        NotificationSetting IJsonModel<NotificationSetting>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NotificationSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(NotificationSetting)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeNotificationSetting(document.RootElement, options);
        }

        internal static NotificationSetting DeserializeNotificationSetting(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<string> emails = default;
            IList<EmailNotificationEnableType> emailOn = default;
            IDictionary<string, MachineLearningWebhook> webhooks = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("emails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        emails = null;
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    emails = array;
                    continue;
                }
                if (property.NameEquals("emailOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        emailOn = null;
                        continue;
                    }
                    List<EmailNotificationEnableType> array = new List<EmailNotificationEnableType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new EmailNotificationEnableType(item.GetString()));
                    }
                    emailOn = array;
                    continue;
                }
                if (property.NameEquals("webhooks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        webhooks = null;
                        continue;
                    }
                    Dictionary<string, MachineLearningWebhook> dictionary = new Dictionary<string, MachineLearningWebhook>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, MachineLearningWebhook.DeserializeMachineLearningWebhook(property0.Value, options));
                    }
                    webhooks = dictionary;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new NotificationSetting(emails ?? new ChangeTrackingList<string>(), emailOn ?? new ChangeTrackingList<EmailNotificationEnableType>(), webhooks ?? new ChangeTrackingDictionary<string, MachineLearningWebhook>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Emails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  emails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Emails))
                {
                    if (Emails.Any())
                    {
                        builder.Append("  emails: ");
                        builder.AppendLine("[");
                        foreach (var item in Emails)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EmailOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  emailOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(EmailOn))
                {
                    if (EmailOn.Any())
                    {
                        builder.Append("  emailOn: ");
                        builder.AppendLine("[");
                        foreach (var item in EmailOn)
                        {
                            builder.AppendLine($"    '{item.ToString()}'");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Webhooks), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  webhooks: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Webhooks))
                {
                    if (Webhooks.Any())
                    {
                        builder.Append("  webhooks: ");
                        builder.AppendLine("{");
                        foreach (var item in Webhooks)
                        {
                            builder.Append($"    '{item.Key}': ");
                            BicepSerializationHelpers.AppendChildObject(builder, item.Value, options, 4, false, "  webhooks: ");
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<NotificationSetting>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NotificationSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(NotificationSetting)} does not support writing '{options.Format}' format.");
            }
        }

        NotificationSetting IPersistableModel<NotificationSetting>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<NotificationSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeNotificationSetting(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(NotificationSetting)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<NotificationSetting>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
