// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The enumerated types for the nodes value. </summary>
    internal readonly partial struct NodesValueType : IEquatable<NodesValueType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NodesValueType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NodesValueType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "All";

        /// <summary> All. </summary>
        public static NodesValueType All { get; } = new NodesValueType(AllValue);
        /// <summary> Determines if two <see cref="NodesValueType"/> values are the same. </summary>
        public static bool operator ==(NodesValueType left, NodesValueType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NodesValueType"/> values are not the same. </summary>
        public static bool operator !=(NodesValueType left, NodesValueType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NodesValueType"/>. </summary>
        public static implicit operator NodesValueType(string value) => new NodesValueType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NodesValueType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NodesValueType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
