// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The action enum for networking rule. </summary>
    public readonly partial struct NetworkingRuleAction : IEquatable<NetworkingRuleAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkingRuleAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkingRuleAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Allow. </summary>
        public static NetworkingRuleAction Allow { get; } = new NetworkingRuleAction(AllowValue);
        /// <summary> Deny. </summary>
        public static NetworkingRuleAction Deny { get; } = new NetworkingRuleAction(DenyValue);
        /// <summary> Determines if two <see cref="NetworkingRuleAction"/> values are the same. </summary>
        public static bool operator ==(NetworkingRuleAction left, NetworkingRuleAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkingRuleAction"/> values are not the same. </summary>
        public static bool operator !=(NetworkingRuleAction left, NetworkingRuleAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkingRuleAction"/>. </summary>
        public static implicit operator NetworkingRuleAction(string value) => new NetworkingRuleAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkingRuleAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkingRuleAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
