// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> MPI distribution configuration. </summary>
    public partial class MpiDistributionConfiguration : MachineLearningDistributionConfiguration
    {
        /// <summary> Initializes a new instance of <see cref="MpiDistributionConfiguration"/>. </summary>
        public MpiDistributionConfiguration()
        {
            DistributionType = DistributionType.Mpi;
        }

        /// <summary> Initializes a new instance of <see cref="MpiDistributionConfiguration"/>. </summary>
        /// <param name="distributionType"> [Required] Specifies the type of distribution framework. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="processCountPerInstance"> Number of processes per MPI node. </param>
        internal MpiDistributionConfiguration(DistributionType distributionType, IDictionary<string, BinaryData> serializedAdditionalRawData, int? processCountPerInstance) : base(distributionType, serializedAdditionalRawData)
        {
            ProcessCountPerInstance = processCountPerInstance;
            DistributionType = distributionType;
        }

        /// <summary> Number of processes per MPI node. </summary>
        [WirePath("processCountPerInstance")]
        public int? ProcessCountPerInstance { get; set; }
    }
}
