// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Describes the bind options for the container. </summary>
    public partial class MountBindOptions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MountBindOptions"/>. </summary>
        public MountBindOptions()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MountBindOptions"/>. </summary>
        /// <param name="propagation"> Type of Bind Option. </param>
        /// <param name="doesCreateHostPath"> Indicate whether to create host path. </param>
        /// <param name="selinux"> Mention the selinux options. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MountBindOptions(string propagation, bool? doesCreateHostPath, string selinux, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Propagation = propagation;
            DoesCreateHostPath = doesCreateHostPath;
            Selinux = selinux;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of Bind Option. </summary>
        [WirePath("propagation")]
        public string Propagation { get; set; }
        /// <summary> Indicate whether to create host path. </summary>
        [WirePath("createHostPath")]
        public bool? DoesCreateHostPath { get; set; }
        /// <summary> Mention the selinux options. </summary>
        [WirePath("selinux")]
        public string Selinux { get; set; }
    }
}
