// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MonitoringNotificationType. </summary>
    public readonly partial struct MonitoringNotificationType : IEquatable<MonitoringNotificationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitoringNotificationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitoringNotificationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AmlNotificationValue = "AmlNotification";

        /// <summary> Enables email notifications through AML notifications. </summary>
        public static MonitoringNotificationType AmlNotification { get; } = new MonitoringNotificationType(AmlNotificationValue);
        /// <summary> Determines if two <see cref="MonitoringNotificationType"/> values are the same. </summary>
        public static bool operator ==(MonitoringNotificationType left, MonitoringNotificationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitoringNotificationType"/> values are not the same. </summary>
        public static bool operator !=(MonitoringNotificationType left, MonitoringNotificationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitoringNotificationType"/>. </summary>
        public static implicit operator MonitoringNotificationType(string value) => new MonitoringNotificationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitoringNotificationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitoringNotificationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
