// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Monitoring input data type enum. </summary>
    internal readonly partial struct MonitoringInputDataType : IEquatable<MonitoringInputDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitoringInputDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitoringInputDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StaticValue = "Static";
        private const string RollingValue = "Rolling";
        private const string FixedValue = "Fixed";

        /// <summary> An input data with a fixed window size. </summary>
        public static MonitoringInputDataType Static { get; } = new MonitoringInputDataType(StaticValue);
        /// <summary> An input data which rolls relatively to the monitor's current run time. </summary>
        public static MonitoringInputDataType Rolling { get; } = new MonitoringInputDataType(RollingValue);
        /// <summary> An input data with tabular format which doesn't require preprocessing. </summary>
        public static MonitoringInputDataType Fixed { get; } = new MonitoringInputDataType(FixedValue);
        /// <summary> Determines if two <see cref="MonitoringInputDataType"/> values are the same. </summary>
        public static bool operator ==(MonitoringInputDataType left, MonitoringInputDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitoringInputDataType"/> values are not the same. </summary>
        public static bool operator !=(MonitoringInputDataType left, MonitoringInputDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitoringInputDataType"/>. </summary>
        public static implicit operator MonitoringInputDataType(string value) => new MonitoringInputDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitoringInputDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitoringInputDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
