// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MonitoringFeatureDataType. </summary>
    public readonly partial struct MonitoringFeatureDataType : IEquatable<MonitoringFeatureDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitoringFeatureDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitoringFeatureDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NumericalValue = "Numerical";
        private const string CategoricalValue = "Categorical";

        /// <summary> Used for features of numerical data type. </summary>
        public static MonitoringFeatureDataType Numerical { get; } = new MonitoringFeatureDataType(NumericalValue);
        /// <summary> Used for features of categorical data type. </summary>
        public static MonitoringFeatureDataType Categorical { get; } = new MonitoringFeatureDataType(CategoricalValue);
        /// <summary> Determines if two <see cref="MonitoringFeatureDataType"/> values are the same. </summary>
        public static bool operator ==(MonitoringFeatureDataType left, MonitoringFeatureDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitoringFeatureDataType"/> values are not the same. </summary>
        public static bool operator !=(MonitoringFeatureDataType left, MonitoringFeatureDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitoringFeatureDataType"/>. </summary>
        public static implicit operator MonitoringFeatureDataType(string value) => new MonitoringFeatureDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitoringFeatureDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitoringFeatureDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
