// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MonitorNotificationSettings. </summary>
    internal partial class MonitorNotificationSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorNotificationSettings"/>. </summary>
        public MonitorNotificationSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MonitorNotificationSettings"/>. </summary>
        /// <param name="emailNotificationSettings"> The AML notification email settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorNotificationSettings(MonitorEmailNotificationSettings emailNotificationSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EmailNotificationSettings = emailNotificationSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The AML notification email settings. </summary>
        internal MonitorEmailNotificationSettings EmailNotificationSettings { get; set; }
        /// <summary> The email recipient list which has a limitation of 499 characters in total. </summary>
        [WirePath("emailNotificationSettings.emails")]
        public IList<string> Emails
        {
            get => EmailNotificationSettings is null ? default : EmailNotificationSettings.Emails;
            set
            {
                if (EmailNotificationSettings is null)
                    EmailNotificationSettings = new MonitorEmailNotificationSettings();
                EmailNotificationSettings.Emails = value;
            }
        }
    }
}
