// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MonitorDefinition. </summary>
    public partial class MonitorDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorDefinition"/>. </summary>
        /// <param name="signals">
        /// [Required] The signals to monitor.
        /// Please note <see cref="MonitoringSignalBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="CustomMonitoringSignal"/>, <see cref="DataDriftMonitoringSignal"/>, <see cref="DataQualityMonitoringSignal"/>, <see cref="FeatureAttributionDriftMonitoringSignal"/> and <see cref="PredictionDriftMonitoringSignal"/>.
        /// </param>
        /// <param name="computeConfiguration">
        /// [Required] The ARM resource ID of the compute resource to run the monitoring job on.
        /// Please note <see cref="MonitorComputeConfigurationBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MonitorServerlessSparkCompute"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="signals"/> or <paramref name="computeConfiguration"/> is null. </exception>
        public MonitorDefinition(IDictionary<string, MonitoringSignalBase> signals, MonitorComputeConfigurationBase computeConfiguration)
        {
            Argument.AssertNotNull(signals, nameof(signals));
            Argument.AssertNotNull(computeConfiguration, nameof(computeConfiguration));

            Signals = signals;
            ComputeConfiguration = computeConfiguration;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorDefinition"/>. </summary>
        /// <param name="monitoringTarget"> The entities targeted by the monitor. </param>
        /// <param name="signals">
        /// [Required] The signals to monitor.
        /// Please note <see cref="MonitoringSignalBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="CustomMonitoringSignal"/>, <see cref="DataDriftMonitoringSignal"/>, <see cref="DataQualityMonitoringSignal"/>, <see cref="FeatureAttributionDriftMonitoringSignal"/> and <see cref="PredictionDriftMonitoringSignal"/>.
        /// </param>
        /// <param name="computeConfiguration">
        /// [Required] The ARM resource ID of the compute resource to run the monitoring job on.
        /// Please note <see cref="MonitorComputeConfigurationBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MonitorServerlessSparkCompute"/>.
        /// </param>
        /// <param name="alertNotificationSettings"> The monitor's notification settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorDefinition(MonitoringTarget monitoringTarget, IDictionary<string, MonitoringSignalBase> signals, MonitorComputeConfigurationBase computeConfiguration, MonitorNotificationSettings alertNotificationSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MonitoringTarget = monitoringTarget;
            Signals = signals;
            ComputeConfiguration = computeConfiguration;
            AlertNotificationSettings = alertNotificationSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorDefinition"/> for deserialization. </summary>
        internal MonitorDefinition()
        {
        }

        /// <summary> The entities targeted by the monitor. </summary>
        [WirePath("monitoringTarget")]
        public MonitoringTarget MonitoringTarget { get; set; }
        /// <summary>
        /// [Required] The signals to monitor.
        /// Please note <see cref="MonitoringSignalBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="CustomMonitoringSignal"/>, <see cref="DataDriftMonitoringSignal"/>, <see cref="DataQualityMonitoringSignal"/>, <see cref="FeatureAttributionDriftMonitoringSignal"/> and <see cref="PredictionDriftMonitoringSignal"/>.
        /// </summary>
        [WirePath("signals")]
        public IDictionary<string, MonitoringSignalBase> Signals { get; }
        /// <summary>
        /// [Required] The ARM resource ID of the compute resource to run the monitoring job on.
        /// Please note <see cref="MonitorComputeConfigurationBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MonitorServerlessSparkCompute"/>.
        /// </summary>
        [WirePath("computeConfiguration")]
        public MonitorComputeConfigurationBase ComputeConfiguration { get; set; }
        /// <summary> The monitor's notification settings. </summary>
        internal MonitorNotificationSettings AlertNotificationSettings { get; set; }
        /// <summary> The email recipient list which has a limitation of 499 characters in total. </summary>
        [WirePath("alertNotificationSettings.emailNotificationSettings.emails")]
        public IList<string> Emails
        {
            get => AlertNotificationSettings is null ? default : AlertNotificationSettings.Emails;
            set
            {
                if (AlertNotificationSettings is null)
                    AlertNotificationSettings = new MonitorNotificationSettings();
                AlertNotificationSettings.Emails = value;
            }
        }
    }
}
