// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Monitor compute type enum. </summary>
    internal readonly partial struct MonitorComputeType : IEquatable<MonitorComputeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorComputeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorComputeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServerlessSparkValue = "ServerlessSpark";

        /// <summary> Serverless Spark compute. </summary>
        public static MonitorComputeType ServerlessSpark { get; } = new MonitorComputeType(ServerlessSparkValue);
        /// <summary> Determines if two <see cref="MonitorComputeType"/> values are the same. </summary>
        public static bool operator ==(MonitorComputeType left, MonitorComputeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorComputeType"/> values are not the same. </summary>
        public static bool operator !=(MonitorComputeType left, MonitorComputeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorComputeType"/>. </summary>
        public static implicit operator MonitorComputeType(string value) => new MonitorComputeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorComputeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorComputeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
