// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.MachineLearning.Models
{
    [PersistableModelProxy(typeof(UnknownMonitorComputeIdentityBase))]
    public partial class MonitorComputeIdentityBase : IUtf8JsonSerializable, IJsonModel<MonitorComputeIdentityBase>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MonitorComputeIdentityBase>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MonitorComputeIdentityBase>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorComputeIdentityBase>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorComputeIdentityBase)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("computeIdentityType"u8);
            writer.WriteStringValue(ComputeIdentityType.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MonitorComputeIdentityBase IJsonModel<MonitorComputeIdentityBase>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorComputeIdentityBase>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MonitorComputeIdentityBase)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMonitorComputeIdentityBase(document.RootElement, options);
        }

        internal static MonitorComputeIdentityBase DeserializeMonitorComputeIdentityBase(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("computeIdentityType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AmlToken": return AmlTokenComputeIdentity.DeserializeAmlTokenComputeIdentity(element, options);
                    case "ManagedIdentity": return ManagedComputeIdentity.DeserializeManagedComputeIdentity(element, options);
                }
            }
            return UnknownMonitorComputeIdentityBase.DeserializeUnknownMonitorComputeIdentityBase(element, options);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ComputeIdentityType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  computeIdentityType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  computeIdentityType: ");
                builder.AppendLine($"'{ComputeIdentityType.ToString()}'");
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<MonitorComputeIdentityBase>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorComputeIdentityBase>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(MonitorComputeIdentityBase)} does not support writing '{options.Format}' format.");
            }
        }

        MonitorComputeIdentityBase IPersistableModel<MonitorComputeIdentityBase>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MonitorComputeIdentityBase>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMonitorComputeIdentityBase(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MonitorComputeIdentityBase)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MonitorComputeIdentityBase>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
