// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MaterializationSettings. </summary>
    public partial class MaterializationSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MaterializationSettings"/>. </summary>
        public MaterializationSettings()
        {
            SparkConfiguration = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="MaterializationSettings"/>. </summary>
        /// <param name="storeType"> Specifies the stores to which materialization should happen. </param>
        /// <param name="schedule"> Specifies the schedule details. </param>
        /// <param name="notification"> Specifies the notification details. </param>
        /// <param name="resource"> Specifies the compute resource settings. </param>
        /// <param name="sparkConfiguration"> Specifies the spark compute settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MaterializationSettings(MaterializationStoreType? storeType, MachineLearningRecurrenceTrigger schedule, NotificationSetting notification, MaterializationComputeResource resource, IDictionary<string, string> sparkConfiguration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StoreType = storeType;
            Schedule = schedule;
            Notification = notification;
            Resource = resource;
            SparkConfiguration = sparkConfiguration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the stores to which materialization should happen. </summary>
        [WirePath("storeType")]
        public MaterializationStoreType? StoreType { get; set; }
        /// <summary> Specifies the schedule details. </summary>
        [WirePath("schedule")]
        public MachineLearningRecurrenceTrigger Schedule { get; set; }
        /// <summary> Specifies the notification details. </summary>
        [WirePath("notification")]
        public NotificationSetting Notification { get; set; }
        /// <summary> Specifies the compute resource settings. </summary>
        internal MaterializationComputeResource Resource { get; set; }
        /// <summary> Specifies the instance type. </summary>
        [WirePath("resource.instanceType")]
        public string ResourceInstanceType
        {
            get => Resource is null ? default : Resource.InstanceType;
            set
            {
                if (Resource is null)
                    Resource = new MaterializationComputeResource();
                Resource.InstanceType = value;
            }
        }

        /// <summary> Specifies the spark compute settings. </summary>
        [WirePath("sparkConfiguration")]
        public IDictionary<string, string> SparkConfiguration { get; set; }
    }
}
