// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MarketplaceSubscriptionProvisioningState. </summary>
    public readonly partial struct MarketplaceSubscriptionProvisioningState : IEquatable<MarketplaceSubscriptionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MarketplaceSubscriptionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MarketplaceSubscriptionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string UpdatingValue = "Updating";
        private const string CanceledValue = "Canceled";

        /// <summary> MarketplaceSubscription is being created. </summary>
        public static MarketplaceSubscriptionProvisioningState Creating { get; } = new MarketplaceSubscriptionProvisioningState(CreatingValue);
        /// <summary> MarketplaceSubscription is being deleted. </summary>
        public static MarketplaceSubscriptionProvisioningState Deleting { get; } = new MarketplaceSubscriptionProvisioningState(DeletingValue);
        /// <summary> MarketplaceSubscription is successfully provisioned. </summary>
        public static MarketplaceSubscriptionProvisioningState Succeeded { get; } = new MarketplaceSubscriptionProvisioningState(SucceededValue);
        /// <summary> MarketplaceSubscription provisioning failed. </summary>
        public static MarketplaceSubscriptionProvisioningState Failed { get; } = new MarketplaceSubscriptionProvisioningState(FailedValue);
        /// <summary> MarketplaceSubscription is being updated. </summary>
        public static MarketplaceSubscriptionProvisioningState Updating { get; } = new MarketplaceSubscriptionProvisioningState(UpdatingValue);
        /// <summary> Canceled. </summary>
        public static MarketplaceSubscriptionProvisioningState Canceled { get; } = new MarketplaceSubscriptionProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="MarketplaceSubscriptionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(MarketplaceSubscriptionProvisioningState left, MarketplaceSubscriptionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MarketplaceSubscriptionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(MarketplaceSubscriptionProvisioningState left, MarketplaceSubscriptionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MarketplaceSubscriptionProvisioningState"/>. </summary>
        public static implicit operator MarketplaceSubscriptionProvisioningState(string value) => new MarketplaceSubscriptionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MarketplaceSubscriptionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MarketplaceSubscriptionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
