// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Managed Network settings for a machine learning workspace. </summary>
    public partial class ManagedNetworkSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkSettings"/>. </summary>
        public ManagedNetworkSettings()
        {
            OutboundRules = new ChangeTrackingDictionary<string, MachineLearningOutboundRule>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkSettings"/>. </summary>
        /// <param name="isolationMode"> Isolation mode for the managed network of a machine learning workspace. </param>
        /// <param name="networkId"></param>
        /// <param name="outboundRules">
        /// Dictionary of &lt;OutboundRule&gt;
        /// Please note <see cref="MachineLearningOutboundRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FqdnOutboundRule"/>, <see cref="PrivateEndpointOutboundRule"/> and <see cref="ServiceTagOutboundRule"/>.
        /// </param>
        /// <param name="status"> Status of the Provisioning for the managed network of a machine learning workspace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedNetworkSettings(IsolationMode? isolationMode, string networkId, IDictionary<string, MachineLearningOutboundRule> outboundRules, ManagedNetworkProvisionStatus status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsolationMode = isolationMode;
            NetworkId = networkId;
            OutboundRules = outboundRules;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Isolation mode for the managed network of a machine learning workspace. </summary>
        [WirePath("isolationMode")]
        public IsolationMode? IsolationMode { get; set; }
        /// <summary> Gets the network id. </summary>
        [WirePath("networkId")]
        public string NetworkId { get; }
        /// <summary>
        /// Dictionary of &lt;OutboundRule&gt;
        /// Please note <see cref="MachineLearningOutboundRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="FqdnOutboundRule"/>, <see cref="PrivateEndpointOutboundRule"/> and <see cref="ServiceTagOutboundRule"/>.
        /// </summary>
        [WirePath("outboundRules")]
        public IDictionary<string, MachineLearningOutboundRule> OutboundRules { get; set; }
        /// <summary> Status of the Provisioning for the managed network of a machine learning workspace. </summary>
        [WirePath("status")]
        public ManagedNetworkProvisionStatus Status { get; set; }
    }
}
