// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Status of the Provisioning for the managed network of a machine learning workspace. </summary>
    public partial class ManagedNetworkProvisionStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkProvisionStatus"/>. </summary>
        public ManagedNetworkProvisionStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagedNetworkProvisionStatus"/>. </summary>
        /// <param name="sparkReady"></param>
        /// <param name="status"> Status for the managed network of a machine learning workspace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagedNetworkProvisionStatus(bool? sparkReady, ManagedNetworkStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SparkReady = sparkReady;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the spark ready. </summary>
        [WirePath("sparkReady")]
        public bool? SparkReady { get; set; }
        /// <summary> Status for the managed network of a machine learning workspace. </summary>
        [WirePath("status")]
        public ManagedNetworkStatus? Status { get; set; }
    }
}
