// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Credential for user managed identity. </summary>
    public partial class ManagedIdentityCredential : DataReferenceCredential
    {
        /// <summary> Initializes a new instance of <see cref="ManagedIdentityCredential"/>. </summary>
        internal ManagedIdentityCredential()
        {
            CredentialType = DataReferenceCredentialType.ManagedIdentity;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedIdentityCredential"/>. </summary>
        /// <param name="credentialType"> [Required] Credential type used to authentication with storage. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="managedIdentityType"> ManagedIdentityCredential identity type. </param>
        /// <param name="userManagedIdentityResourceId"> Full arm scope for the Id. For ManagedIdentityType = SystemManaged, this field is null. </param>
        /// <param name="userManagedIdentityClientId"> ClientId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </param>
        /// <param name="userManagedIdentityPrincipalId"> PrincipalId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </param>
        /// <param name="userManagedIdentityTenantId"> TenantId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </param>
        internal ManagedIdentityCredential(DataReferenceCredentialType credentialType, IDictionary<string, BinaryData> serializedAdditionalRawData, string managedIdentityType, string userManagedIdentityResourceId, string userManagedIdentityClientId, string userManagedIdentityPrincipalId, string userManagedIdentityTenantId) : base(credentialType, serializedAdditionalRawData)
        {
            ManagedIdentityType = managedIdentityType;
            UserManagedIdentityResourceId = userManagedIdentityResourceId;
            UserManagedIdentityClientId = userManagedIdentityClientId;
            UserManagedIdentityPrincipalId = userManagedIdentityPrincipalId;
            UserManagedIdentityTenantId = userManagedIdentityTenantId;
            CredentialType = credentialType;
        }

        /// <summary> ManagedIdentityCredential identity type. </summary>
        [WirePath("managedIdentityType")]
        public string ManagedIdentityType { get; }
        /// <summary> Full arm scope for the Id. For ManagedIdentityType = SystemManaged, this field is null. </summary>
        [WirePath("userManagedIdentityResourceId")]
        public string UserManagedIdentityResourceId { get; }
        /// <summary> ClientId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </summary>
        [WirePath("userManagedIdentityClientId")]
        public string UserManagedIdentityClientId { get; }
        /// <summary> PrincipalId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </summary>
        [WirePath("userManagedIdentityPrincipalId")]
        public string UserManagedIdentityPrincipalId { get; }
        /// <summary> TenantId for the UAMI. For ManagedIdentityType = SystemManaged, this field is null. </summary>
        [WirePath("userManagedIdentityTenantId")]
        public string UserManagedIdentityTenantId { get; }
    }
}
