// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Managed compute identity definition. </summary>
    public partial class ManagedComputeIdentity : MonitorComputeIdentityBase
    {
        /// <summary> Initializes a new instance of <see cref="ManagedComputeIdentity"/>. </summary>
        public ManagedComputeIdentity()
        {
            ComputeIdentityType = MonitorComputeIdentityType.ManagedIdentity;
        }

        /// <summary> Initializes a new instance of <see cref="ManagedComputeIdentity"/>. </summary>
        /// <param name="computeIdentityType"> [Required] Specifies the type of identity to use within the monitoring jobs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="identity"> The identity which will be leveraged by the monitoring jobs. </param>
        internal ManagedComputeIdentity(MonitorComputeIdentityType computeIdentityType, IDictionary<string, BinaryData> serializedAdditionalRawData, ManagedServiceIdentity identity) : base(computeIdentityType, serializedAdditionalRawData)
        {
            Identity = identity;
            ComputeIdentityType = computeIdentityType;
        }

        /// <summary> The identity which will be leveraged by the monitoring jobs. </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
    }
}
