// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The MachineLearningWorkspaceGetKeysResult. </summary>
    public partial class MachineLearningWorkspaceGetKeysResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningWorkspaceGetKeysResult"/>. </summary>
        internal MachineLearningWorkspaceGetKeysResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningWorkspaceGetKeysResult"/>. </summary>
        /// <param name="userStorageKey"></param>
        /// <param name="userStorageResourceId"></param>
        /// <param name="appInsightsInstrumentationKey"></param>
        /// <param name="containerRegistryCredentials"></param>
        /// <param name="notebookAccessKeys"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningWorkspaceGetKeysResult(string userStorageKey, string userStorageResourceId, string appInsightsInstrumentationKey, MachineLearningContainerRegistryCredentials containerRegistryCredentials, MachineLearningWorkspaceGetNotebookKeysResult notebookAccessKeys, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserStorageKey = userStorageKey;
            UserStorageResourceId = userStorageResourceId;
            AppInsightsInstrumentationKey = appInsightsInstrumentationKey;
            ContainerRegistryCredentials = containerRegistryCredentials;
            NotebookAccessKeys = notebookAccessKeys;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the user storage key. </summary>
        [WirePath("userStorageKey")]
        public string UserStorageKey { get; }
        /// <summary> Gets the user storage resource id. </summary>
        [WirePath("userStorageResourceId")]
        public string UserStorageResourceId { get; }
        /// <summary> Gets the app insights instrumentation key. </summary>
        [WirePath("appInsightsInstrumentationKey")]
        public string AppInsightsInstrumentationKey { get; }
        /// <summary> Gets the container registry credentials. </summary>
        [WirePath("containerRegistryCredentials")]
        public MachineLearningContainerRegistryCredentials ContainerRegistryCredentials { get; }
        /// <summary> Gets the notebook access keys. </summary>
        [WirePath("notebookAccessKeys")]
        public MachineLearningWorkspaceGetNotebookKeysResult NotebookAccessKeys { get; }
    }
}
