// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Enum to determine the webhook callback service type. </summary>
    internal readonly partial struct MachineLearningWebhookType : IEquatable<MachineLearningWebhookType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningWebhookType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningWebhookType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureDevOpsValue = "AzureDevOps";

        /// <summary> AzureDevOps. </summary>
        public static MachineLearningWebhookType AzureDevOps { get; } = new MachineLearningWebhookType(AzureDevOpsValue);
        /// <summary> Determines if two <see cref="MachineLearningWebhookType"/> values are the same. </summary>
        public static bool operator ==(MachineLearningWebhookType left, MachineLearningWebhookType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningWebhookType"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningWebhookType left, MachineLearningWebhookType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningWebhookType"/>. </summary>
        public static implicit operator MachineLearningWebhookType(string value) => new MachineLearningWebhookType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningWebhookType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningWebhookType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
