// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> The type of the VM. </summary>
    public readonly partial struct MachineLearningVmTier : IEquatable<MachineLearningVmTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineLearningVmTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineLearningVmTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string LowPriorityValue = "LowPriority";
        private const string SpotValue = "Spot";

        /// <summary> Standard. </summary>
        public static MachineLearningVmTier Standard { get; } = new MachineLearningVmTier(StandardValue);
        /// <summary> LowPriority. </summary>
        public static MachineLearningVmTier LowPriority { get; } = new MachineLearningVmTier(LowPriorityValue);
        /// <summary> Spot. </summary>
        public static MachineLearningVmTier Spot { get; } = new MachineLearningVmTier(SpotValue);
        /// <summary> Determines if two <see cref="MachineLearningVmTier"/> values are the same. </summary>
        public static bool operator ==(MachineLearningVmTier left, MachineLearningVmTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineLearningVmTier"/> values are not the same. </summary>
        public static bool operator !=(MachineLearningVmTier left, MachineLearningVmTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineLearningVmTier"/>. </summary>
        public static implicit operator MachineLearningVmTier(string value) => new MachineLearningVmTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineLearningVmTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineLearningVmTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
