// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.MachineLearning.Models
{
    /// <summary> Admin credentials for virtual machine. </summary>
    public partial class MachineLearningVmSshCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningVmSshCredentials"/>. </summary>
        public MachineLearningVmSshCredentials()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningVmSshCredentials"/>. </summary>
        /// <param name="username"> Username of admin account. </param>
        /// <param name="password"> Password of admin account. </param>
        /// <param name="publicKeyData"> Public key data. </param>
        /// <param name="privateKeyData"> Private key data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningVmSshCredentials(string username, string password, string publicKeyData, string privateKeyData, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Username = username;
            Password = password;
            PublicKeyData = publicKeyData;
            PrivateKeyData = privateKeyData;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Username of admin account. </summary>
        [WirePath("username")]
        public string Username { get; set; }
        /// <summary> Password of admin account. </summary>
        [WirePath("password")]
        public string Password { get; set; }
        /// <summary> Public key data. </summary>
        [WirePath("publicKeyData")]
        public string PublicKeyData { get; set; }
        /// <summary> Private key data. </summary>
        [WirePath("privateKeyData")]
        public string PrivateKeyData { get; set; }
    }
}
